-- ================================================================
-- FIX MISSING COLUMNS - Complete Migration
-- ================================================================
-- Run this in cPanel → phpMyAdmin → SQL tab
-- This adds all missing columns needed by the dashboard
-- Time: 1-2 minutes
-- ================================================================

-- Step 1: Add fee_amount column (alias for platform_fee)
-- Check if column exists first
SET @col_exists = (
    SELECT COUNT(*) 
    FROM INFORMATION_SCHEMA.COLUMNS 
    WHERE TABLE_NAME = 'platform_fees' 
    AND COLUMN_NAME = 'fee_amount'
);

-- Add fee_amount if it doesn't exist
ALTER TABLE `platform_fees` 
ADD COLUMN IF NOT EXISTS `fee_amount` DECIMAL(10,2) NOT NULL DEFAULT 0.00 
COMMENT 'Platform fee amount (same as platform_fee)' 
AFTER `platform_fee`;

-- Copy data from platform_fee to fee_amount
UPDATE `platform_fees` 
SET `fee_amount` = `platform_fee`
WHERE `fee_amount` = 0 OR `fee_amount` IS NULL;

-- Step 2: Add gross_amount column (alias for total_amount)
ALTER TABLE `platform_fees` 
ADD COLUMN IF NOT EXISTS `gross_amount` DECIMAL(10,2) NOT NULL DEFAULT 0.00 
COMMENT 'Total transaction amount (same as total_amount)' 
AFTER `total_amount`;

-- Copy data from total_amount to gross_amount
UPDATE `platform_fees` 
SET `gross_amount` = `total_amount`
WHERE `gross_amount` = 0 OR `gross_amount` IS NULL;

-- Step 3: Add admin_id column if missing
ALTER TABLE `platform_fees` 
ADD COLUMN IF NOT EXISTS `admin_id` INT(11) NULL 
COMMENT 'Admin who receives the fee' 
AFTER `student_id`;

-- Try to populate admin_id from the associated payment/student
UPDATE `platform_fees` pf
INNER JOIN `payments` p ON pf.payment_id = p.id
INNER JOIN `students` s ON p.student_id = s.id
INNER JOIN `admins` a ON a.academy_reference = s.academy_reference
SET pf.admin_id = a.id
WHERE pf.admin_id IS NULL;

-- Step 4: Add academy_reference to platform_fees if missing
ALTER TABLE `platform_fees` 
ADD COLUMN IF NOT EXISTS `academy_reference` VARCHAR(50) NULL 
COMMENT 'School reference code' 
AFTER `admin_id`;

-- Populate academy_reference from payments
UPDATE `platform_fees` pf
INNER JOIN `payments` p ON pf.payment_id = p.id
SET pf.academy_reference = p.academy_reference
WHERE pf.academy_reference IS NULL OR pf.academy_reference = '';

-- Step 5: Verify the changes
SELECT 
    'platform_fees' as table_name,
    COUNT(*) as total_records,
    COUNT(fee_amount) as has_fee_amount,
    COUNT(gross_amount) as has_gross_amount,
    COUNT(admin_id) as has_admin_id,
    COUNT(academy_reference) as has_academy_ref
FROM platform_fees;

-- Step 6: Show sample data to verify
SELECT 
    id,
    payment_id,
    total_amount,
    gross_amount,
    platform_fee,
    fee_amount,
    admin_earnings,
    academy_reference
FROM platform_fees
LIMIT 5;

-- ================================================================
-- DONE! Refresh your dashboard - it should work now!
-- ================================================================

-- Optional: Add indexes for better performance
ALTER TABLE `platform_fees` 
ADD INDEX IF NOT EXISTS `idx_admin_id` (`admin_id`),
ADD INDEX IF NOT EXISTS `idx_academy_reference` (`academy_reference`);

